//roundedBar(3, 25, 6, 2, true);
roundedBar(2,15,10,2, false);

$fn = 100;

module roundedBar(barThickness, barLength, barWidth, holeRadius, doubleSidedTF){
    echo ("roundedBar(barThickness, barLength, barWidth, holeRadius, doubleSidedTF)");
    translate([0, barLength/2, 0]){
        roundedBarBody(barThickness, barLength, barWidth, holeRadius, doubleSidedTF);
    }
    translate([0, barLength, 0]){
        roundedBarEnd(barThickness, barWidth, holeRadius);
    }
    if(doubleSidedTF == true){
        translate([0, 0, 0]){
            roundedBarEnd(barThickness, barWidth, holeRadius);
        }
    }
}

module roundedBarEnd(barThickness, barWidth, holeRadius){
    difference(){
        cylinder(barThickness, barWidth/2, barWidth/2, center = true);
        cylinder(barThickness + 1, holeRadius, holeRadius, center = true);
    }
}

module roundedBarBody(barThickness, barLength, barWidth, holeRadius, doubleSidedTF){
    difference(){
        cube([barWidth, barLength, barThickness], center = true);
        translate([0, barLength/2, 0]){
            cylinder(barThickness*4, holeRadius, holeRadius, center = true);
        }
        if(doubleSidedTF == true){
            translate([0, -barLength/2, barWidth/2]){
                cylinder(barThickness*4, holeRadius, holeRadius, center = true);
            }
        }
    }
}